#include "conf.h"
#include "hxd_config.h"
#include "hxd_wanted.c"
#include <string.h>

struct hxd_config hxd_cfg;

void
hxd_config_init (struct hxd_config *cfg)
{
	static int got_default = 0;

	memset(cfg, 0, sizeof(struct hxd_config));
	if (!got_default) {
		conf_wanted_to_config(&hxd_config_default, &hxd_wanted_t0s0);
		got_default = 1;
	}
	memcpy(cfg, &hxd_config_default, sizeof(struct hxd_config));
}

void
hxd_config_read (const char *fname, struct hxd_config *cfg)
{
	struct wanted *wtop;

	wtop = conf_read(fname, &hxd_wanted_t0s0);
	if (!wtop)
		return;
	conf_wanted_to_config(cfg, wtop);
	conf_freevars(wtop);
}
